
// Copyright  2002-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_IO_PAK_H_
#define _NEUROSIS_ENGINE_IO_PAK_H_

/***************************************************************************/

struct SPakHeader {
	char		mSignature[8];															// Signature (LP23.COM)
	float		mVersion;																		// Version number (1.0)
	DWORD		mFileEntries;																// Number of file table entries
	char		mID[10];																		// ID (Random)
};

/***************************************************************************/

struct SFileTableEntry {
	char						mFilename[30];											// Name of one file in the PAK
	DWORD						mFileSize;													// The size of the file in bytes
	DWORD						mFileOffset;												// Offset of file in the PAK
	SFileTableEntry	*pNext;															// Next file table entry (is a linked list)
};

/***************************************************************************/
#define CYPHER_VALUE 23

class CPakFile
{
	private:
		char						mFolderPath[300];									// Location of folder to compile
		char						mPakName[300];										// Location to save PAK
		SPakHeader			mHeader;													// The header of the PAK file
		SFileTableEntry *mFileTable;											// The master file table for the PAK

		bool	Generate();																	// Create header and file table
		bool	WorkOutOffsets();														// Work out the file offsets in the PAK

public:
					CPakFile();
		//! Constructor/Deconstructor
					~CPakFile();

		//! Clear current data
		bool	Clear();
		//! Create file - if checkModifiedDate is true, outputFile is only created if none found or is older than the files in inputFolder
		bool	Create(char *inputFolder, char *outputFile, bool checkModifiedDate = false);
		//! Load PAK header and file table
		bool	Load(char *filename);
		//! Extract every file from PAK
		bool	Extract();
		//! Extract only one file from PAK
		bool	Extract_File(char *filename);
};

/***************************************************************************/
#endif